/***********************************************************************/
/*          API-GPIB(98/PC)W95,NT         C++/CLI Header File          */
/*                                                File Name CGpibCLI.H */
/***********************************************************************/
#pragma once

using namespace System;
using namespace System::Text;
using namespace System::Runtime::InteropServices;

namespace CGpibCLI
{
	[DllImport("apigpib1.dll")] unsigned long GpIni();
	[DllImport("apigpib1.dll")] unsigned long GpIfc(unsigned long IfcTime);
	[DllImport("apigpib1.dll")] unsigned long GpRen(void);
	[DllImport("apigpib1.dll")] unsigned long GpResetren(void);
	[DllImport("apigpib1.dll")] unsigned long GpTalk(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListen(array<unsigned long>^  Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpPoll(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb);
	[DllImport("apigpib1.dll")] unsigned long GpSrq(unsigned long Eoi);
	[DllImport("apigpib1.dll")] unsigned long GpStb(unsigned long Stb);
	[DllImport("apigpib1.dll")] unsigned long GpDelim(unsigned long Delim, unsigned long Eoi);
	[DllImport("apigpib1.dll")] unsigned long GpTimeout(unsigned long Timeout);
	[DllImport("apigpib1.dll")] unsigned long GpChkstb(unsigned long * Stb, unsigned long * Eoi);
	[DllImport("apigpib1.dll")] unsigned long GpReadreg(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib1.dll")] unsigned long GpDma(unsigned long Dmamode, unsigned long Dmach);
	[DllImport("apigpib1.dll")] unsigned long GpExit(void);
	[DllImport("apigpib1.dll")] unsigned long GpComand(array<unsigned long>^ Cmd);
	[DllImport("apigpib1.dll")] unsigned long GpDmainuse(void);
	[DllImport("apigpib1.dll")] unsigned long GpStstop(unsigned long Stp);
	[DllImport("apigpib1.dll")] unsigned long GpDmastop(void);
	[DllImport("apigpib1.dll")] unsigned long GpPpollmode(unsigned long Pmode);
	[DllImport("apigpib1.dll")] unsigned long GpStppoll(array<unsigned long>^ Cmd, unsigned long Stppu);
	[DllImport("apigpib1.dll")] unsigned long GpExppoll(unsigned long * Pprdata);
	[DllImport("apigpib1.dll")] unsigned long GpStwait(unsigned long Buscode);
	[DllImport("apigpib1.dll")] unsigned long GpWaittime(unsigned long Timeout);
	[DllImport("apigpib1.dll")] unsigned long GpReadbus(unsigned long * Bussta);
	[DllImport("apigpib1.dll")] unsigned long GpSfile(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib1.dll")] unsigned long GpRfile(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib1.dll")] unsigned long GpSdc(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpDcl(void);
	[DllImport("apigpib1.dll")] unsigned long GpGet(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpGtl(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpLlo(void);
	[DllImport("apigpib1.dll")] unsigned long GpTct(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCrst(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCopc(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCwai(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCcls(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCtrg(unsigned long Adr);
	[DllImport("apigpib1.dll")] unsigned long GpCpre(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib1.dll")] unsigned long GpCese(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib1.dll")] unsigned long GpCsre(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib1.dll")] unsigned long GpQidn(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQopt(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpud(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQrdt(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQcal(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQlrn(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQtst(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQopc(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQemc(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQgmc(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQlmc(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQist(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpre(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQese(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQesr(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpsc(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQsre(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQstb(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQddt(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpTaLaBit(unsigned long TaLaSts);
	[DllImport("apigpib1.dll")] unsigned long GpBoardsts(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib1.dll")] unsigned long GpSrqEvent(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib1.dll")] unsigned long GpSrqEventEx(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib1.dll")] unsigned long GpSrqOn();
	[DllImport("apigpib1.dll")] unsigned long GpDevFind(array<unsigned long>^ Fstb);
	[DllImport("apigpib1.dll")] unsigned long GpInpB(unsigned short Port);
	[DllImport("apigpib1.dll")] unsigned long GpInpW(unsigned short Port);
	[DllImport("apigpib1.dll")] unsigned long GpInpD(unsigned short Port);
	[DllImport("apigpib1.dll")] unsigned long GpOutB(unsigned short Port, Byte Dat);
	[DllImport("apigpib1.dll")] unsigned long GpOutW(unsigned short Port, unsigned short Dat);
	[DllImport("apigpib1.dll")] unsigned long GpOutD(unsigned short Port, unsigned long Dat);
	[DllImport("apigpib1.dll")] unsigned long GpSetEvent(unsigned long EventOn);
	[DllImport("apigpib1.dll")] unsigned long GpSetEventSrq(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib1.dll")] unsigned long GpSetEventDet(int hWnd, unsigned short wMsg, unsigned long DetOn);
	[DllImport("apigpib1.dll")] unsigned long GpSetEventDec(int hWnd, unsigned short wMsg, unsigned long DecOn);
	[DllImport("apigpib1.dll")] unsigned long GpSetEventIfc(int hWnd, unsigned short wMsg, unsigned long IfcOn);
	[DllImport("apigpib1.dll")] unsigned long GpEnableNextEvent(void);
	[DllImport("apigpib1.dll")] unsigned long GpSrqEx(unsigned long Stb, unsigned long SrqFlag, unsigned long EoiFlag);
	[DllImport("apigpib1.dll")] unsigned long GpUpperCode(unsigned long UpperCode);
	[DllImport("apigpib1.dll")] unsigned long GpCnvSettings(String^ HeaderStr, String^ UnitStr, String^ SepStr, unsigned long SfxFlag);
	[DllImport("apigpib1.dll")] unsigned long GpCnvSettingsToStr(unsigned long PlusFlag, unsigned long Digit, unsigned long CutDown);	
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToDbl(String^ Str, double * DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToDblArray(String^ Str, array<double>^ DblData, unsigned long * ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToFlt(String^ Str, float * FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToFltArray(String^ Str, array<float>^ FltData, unsigned long * ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvDblToStr(StringBuilder^ Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvDblArrayToStr(StringBuilder^ Str, unsigned long * StrSize, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvFltToStr(StringBuilder^ Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvFltArrayToStr(StringBuilder^ Str, unsigned long * StrSize, array<float>^ FltData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpPollEx(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb, array<unsigned long>^ Psrq);
	[DllImport("apigpib1.dll")] unsigned long GpSlowMode(unsigned long SlowTime);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvSettings(unsigned long Settings);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvi(array<Byte>^ Str, short* ShtData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCviArray(array<Byte>^ Str, array<short>^ ShtData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvs(array<Byte>^ Str, float* FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvsArray(array<Byte>^ Str, array<float>^  FltData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvd(array<Byte>^ Str, double* DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvdArray(array<Byte>^ Str, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpTalkEx(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListenEx(array<unsigned long>^ Cmd, unsigned long * Srlen,StringBuilder^ Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpTalkAsync(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListenAsync(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpCommandAsync(array<unsigned long>^ Cmd);
	[DllImport("apigpib1.dll")] unsigned long GpCheckAsync(unsigned long WaitFlag, unsigned long * ErrCode);
	[DllImport("apigpib1.dll")] unsigned long GpStopAsync(void);
	[DllImport("apigpib1.dll")] unsigned long GpDevFindEx(short Pad, short Sad, short * Lstn);
	[DllImport("apigpib1.dll")] unsigned long GpBoardstsEx(unsigned long SetFlag, unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib1.dll")] unsigned long GpSmoothMode(unsigned long Mode);

	[DllImport("apigpib1.dll")] unsigned long GpTalk(unsigned long * Cmd, unsigned long Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListen(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpPoll(unsigned long * Cmd, unsigned long * Pstb);
	[DllImport("apigpib1.dll")] unsigned long GpComand(unsigned long * Cmd);
	[DllImport("apigpib1.dll")] unsigned long GpStppoll(unsigned long * Cmd, unsigned long Stppu);
	[DllImport("apigpib1.dll")] unsigned long GpSfile(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib1.dll")] unsigned long GpRfile(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib1.dll")] unsigned long GpQidn(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQopt(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpud(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQrdt(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQcal(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQlrn(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQtst(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQopc(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQemc(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQgmc(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQlmc(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQist(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpre(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQese(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQesr(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQpsc(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQsre(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQstb(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpQddt(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpDevFind(unsigned long * Fstb);
	[DllImport("apigpib1.dll")] unsigned long GpCnvSettings(unsigned char * HeaderStr, unsigned char * UnitStr, unsigned char * SepStr, unsigned long SfxFlag);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToDbl(unsigned char * Str, double * DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToDblArray(unsigned char * Str, double* DblData, unsigned long * ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToFlt(unsigned char * Str, float * FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvStrToFltArray(unsigned char * Str, float * FltData, unsigned long * ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvDblToStr(unsigned char * Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvDblArrayToStr(unsigned char * Str, unsigned long * StrSize, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvFltToStr(unsigned char * Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvFltArrayToStr(unsigned char * Str, unsigned long * StrSize, float * FltData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpPollEx(unsigned long * Cmd, unsigned long * Pstb, unsigned long * Psrq);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvi(unsigned char * Str, short* ShtData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCviArray(unsigned char * Str, short * ShtData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvs(unsigned char * Str, float* FltData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvsArray(unsigned char * Str, float *  FltData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvd(unsigned char * Str, double* DblData);
	[DllImport("apigpib1.dll")] unsigned long GpCnvCvdArray(unsigned char * Str, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib1.dll")] unsigned long GpTalkEx(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListenEx(unsigned long * Cmd, unsigned long * Srlen,unsigned char * Srbuf);
	[DllImport("apigpib1.dll")] unsigned long GpTalkAsync(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpListenAsync(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib1.dll")] unsigned long GpCommandAsync(unsigned long * Cmd);

	[DllImport("apigpib2.dll")] unsigned long GpIni2();
	[DllImport("apigpib2.dll")] unsigned long GpIfc2(unsigned long IfcTime);
	[DllImport("apigpib2.dll")] unsigned long GpRen2(void);
	[DllImport("apigpib2.dll")] unsigned long GpResetren2(void);
	[DllImport("apigpib2.dll")] unsigned long GpTalk2(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListen2(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpPoll2(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb);
	[DllImport("apigpib2.dll")] unsigned long GpSrq2(unsigned long Eoi);
	[DllImport("apigpib2.dll")] unsigned long GpStb2(unsigned long Stb);
	[DllImport("apigpib2.dll")] unsigned long GpDelim2(unsigned long Delim, unsigned long Eoi);
	[DllImport("apigpib2.dll")] unsigned long GpTimeout2(unsigned long Timeout);
	[DllImport("apigpib2.dll")] unsigned long GpChkstb2(unsigned long * Stb, unsigned long * Eoi);
	[DllImport("apigpib2.dll")] unsigned long GpReadreg2(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib2.dll")] unsigned long GpDma2(unsigned long Dmamode, unsigned long Dmach);
	[DllImport("apigpib2.dll")] unsigned long GpExit2(void);
	[DllImport("apigpib2.dll")] unsigned long GpComand2(array<unsigned long>^ Cmd);
	[DllImport("apigpib2.dll")] unsigned long GpDmainuse2(void);
	[DllImport("apigpib2.dll")] unsigned long GpStstop2(unsigned long Stp);
	[DllImport("apigpib2.dll")] unsigned long GpDmastop2(void);
	[DllImport("apigpib2.dll")] unsigned long GpPpollmode2(unsigned long Pmode);
	[DllImport("apigpib2.dll")] unsigned long GpStppoll2(array<unsigned long>^ Cmd, unsigned long Stppu);
	[DllImport("apigpib2.dll")] unsigned long GpExppoll2(unsigned long * Pprdata);
	[DllImport("apigpib2.dll")] unsigned long GpStwait2(unsigned long Buscode);
	[DllImport("apigpib2.dll")] unsigned long GpWaittime2(unsigned long Timeout);
	[DllImport("apigpib2.dll")] unsigned long GpReadbus2(unsigned long * Bussta);
	[DllImport("apigpib2.dll")] unsigned long GpSfile2(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib2.dll")] unsigned long GpRfile2(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib2.dll")] unsigned long GpSdc2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpDcl2(void);
	[DllImport("apigpib2.dll")] unsigned long GpGet2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpGtl2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpLlo2(void);
	[DllImport("apigpib2.dll")] unsigned long GpTct2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCrst2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCopc2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCwai2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCcls2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCtrg2(unsigned long Adr);
	[DllImport("apigpib2.dll")] unsigned long GpCpre2(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib2.dll")] unsigned long GpCese2(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib2.dll")] unsigned long GpCsre2(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib2.dll")] unsigned long GpQidn2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQopt2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpud2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQrdt2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQcal2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQlrn2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQtst2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQopc2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQemc2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQgmc2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQlmc2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQist2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpre2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQese2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQesr2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpsc2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQsre2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQstb2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQddt2(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpTaLaBit2(unsigned long TaLaSts);
	[DllImport("apigpib2.dll")] unsigned long GpBoardsts2(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib2.dll")] unsigned long GpSrqEvent2(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib2.dll")] unsigned long GpSrqEventEx2(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib2.dll")] unsigned long GpSrqOn2();
	[DllImport("apigpib2.dll")] unsigned long GpDevFind2(array<unsigned long>^ Fstb);
	[DllImport("apigpib2.dll")] unsigned long GpInpB2(unsigned short Port);
	[DllImport("apigpib2.dll")] unsigned long GpInpW2(unsigned short Port);
	[DllImport("apigpib2.dll")] unsigned long GpInpD2(unsigned short Port);
	[DllImport("apigpib2.dll")] unsigned long GpOutB2(unsigned short Port, Byte Dat);
	[DllImport("apigpib2.dll")] unsigned long GpOutW2(unsigned short Port, unsigned short Dat);
	[DllImport("apigpib2.dll")] unsigned long GpOutD2(unsigned short Port, unsigned long Dat);
	[DllImport("apigpib2.dll")] unsigned long GpSetEvent2(unsigned long EventOn);
	[DllImport("apigpib2.dll")] unsigned long GpSetEventSrq2(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib2.dll")] unsigned long GpSetEventDet2(int hWnd, unsigned short wMsg, unsigned long DetOn);
	[DllImport("apigpib2.dll")] unsigned long GpSetEventDec2(int hWnd, unsigned short wMsg, unsigned long DecOn);
	[DllImport("apigpib2.dll")] unsigned long GpSetEventIfc2(int hWnd, unsigned short wMsg, unsigned long IfcOn);
	[DllImport("apigpib2.dll")] unsigned long GpEnableNextEvent2(void);
	[DllImport("apigpib2.dll")] unsigned long GpSrqEx2(unsigned long Stb, unsigned long SrqFlag, unsigned long EoiFlag);
	[DllImport("apigpib2.dll")] unsigned long GpUpperCode2(unsigned long UpperCode);
	[DllImport("apigpib2.dll")] unsigned long GpCnvSettings2(String^ HeaderStr, String^ UnitStr, String^ SepStr, unsigned long SfxFlag);
	[DllImport("apigpib2.dll")] unsigned long GpCnvSettingsToStr2(unsigned long PlusFlag, unsigned long Digit, unsigned long CutDown);
	
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToDbl2(String^ Str, double * DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToDblArray2(String^ Str, array<double>^ DblData, unsigned long * ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToFlt2(String^ Str, float * FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToFltArray2(String^ Str, array<float>^ FltData, unsigned long * ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvDblToStr2(StringBuilder^ Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvDblArrayToStr2(StringBuilder^ Str, unsigned long * StrSize, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvFltToStr2(StringBuilder^ Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvFltArrayToStr2(StringBuilder^ Str, unsigned long * StrSize, array<float>^ FltData, unsigned long ArraySize);
	
	[DllImport("apigpib2.dll")] unsigned long GpPollEx2(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb, array<unsigned long>^ Psrq);
	[DllImport("apigpib2.dll")] unsigned long GpSlowMode2(unsigned long SlowTime);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvSettings2(unsigned long Settings);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvi2(array<Byte>^ Str, short* ShtData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCviArray2(array<Byte>^ Str, array<short>^ ShtData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvs2(array<Byte>^ Str, float* FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvsArray2(array<Byte>^ Str, array<float>^  FltData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvd2(array<Byte>^ Str, double* DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvdArray2(array<Byte>^ Str, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpTalkEx2(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListenEx2(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpTalkAsync2(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListenAsync2(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpCommandAsync2(array<unsigned long>^ Cmd);
	[DllImport("apigpib2.dll")] unsigned long GpCheckAsync2(unsigned long WaitFlag, unsigned long * ErrCode);
	[DllImport("apigpib2.dll")] unsigned long GpStopAsync2(void);
	[DllImport("apigpib2.dll")] unsigned long GpDevFindEx2(short Pad, short Sad, short * Lstn);
	[DllImport("apigpib2.dll")] unsigned long GpBoardstsEx2(unsigned long SetFlag, unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib2.dll")] unsigned long GpSmoothMode2(unsigned long Mode);

	[DllImport("apigpib2.dll")] unsigned long GpTalk2(unsigned long * Cmd, unsigned long Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListen2(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpPoll2(unsigned long * Cmd, unsigned long * Pstb);
	[DllImport("apigpib2.dll")] unsigned long GpComand2(unsigned long * Cmd);
	[DllImport("apigpib2.dll")] unsigned long GpStppoll2(unsigned long * Cmd, unsigned long Stppu);
	[DllImport("apigpib2.dll")] unsigned long GpSfile2(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib2.dll")] unsigned long GpRfile2(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib2.dll")] unsigned long GpQidn2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQopt2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpud2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQrdt2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQcal2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQlrn2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQtst2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQopc2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQemc2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQgmc2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQlmc2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQist2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpre2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQese2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQesr2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQpsc2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQsre2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQstb2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpQddt2(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpDevFind2(unsigned long * Fstb);
	[DllImport("apigpib2.dll")] unsigned long GpCnvSettings2(unsigned char * HeaderStr, unsigned char * UnitStr, unsigned char * SepStr, unsigned long SfxFlag);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToDbl2(unsigned char * Str, double * DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToDblArray2(unsigned char * Str, double* DblData, unsigned long * ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToFlt2(unsigned char * Str, float * FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvStrToFltArray2(unsigned char * Str, float * FltData, unsigned long * ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvDblToStr2(unsigned char * Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvDblArrayToStr2(unsigned char * Str, unsigned long * StrSize, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvFltToStr2(unsigned char * Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvFltArrayToStr2(unsigned char * Str, unsigned long * StrSize, float * FltData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpPollEx2(unsigned long * Cmd, unsigned long * Pstb, unsigned long * Psrq);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvi2(unsigned char * Str, short* ShtData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCviArray2(unsigned char * Str, short * ShtData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvs2(unsigned char * Str, float* FltData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvsArray2(unsigned char * Str, float *  FltData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvd2(unsigned char * Str, double* DblData);
	[DllImport("apigpib2.dll")] unsigned long GpCnvCvdArray2(unsigned char * Str, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib2.dll")] unsigned long GpTalkEx2(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListenEx2(unsigned long * Cmd, unsigned long * Srlen,unsigned char * Srbuf);
	[DllImport("apigpib2.dll")] unsigned long GpTalkAsync2(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpListenAsync2(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib2.dll")] unsigned long GpCommandAsync2(unsigned long * Cmd);

	[DllImport("apigpib3.dll")] unsigned long GpIni3();
	[DllImport("apigpib3.dll")] unsigned long GpIfc3(unsigned long IfcTime);
	[DllImport("apigpib3.dll")] unsigned long GpRen3(void);
	[DllImport("apigpib3.dll")] unsigned long GpResetren3(void);
	[DllImport("apigpib3.dll")] unsigned long GpTalk3(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListen3(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpPoll3(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb);
	[DllImport("apigpib3.dll")] unsigned long GpSrq3(unsigned long Eoi);
	[DllImport("apigpib3.dll")] unsigned long GpStb3(unsigned long Stb);
	[DllImport("apigpib3.dll")] unsigned long GpDelim3(unsigned long Delim, unsigned long Eoi);
	[DllImport("apigpib3.dll")] unsigned long GpTimeout3(unsigned long Timeout);
	[DllImport("apigpib3.dll")] unsigned long GpChkstb3(unsigned long * Stb, unsigned long * Eoi);
	[DllImport("apigpib3.dll")] unsigned long GpReadreg3(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib3.dll")] unsigned long GpDma3(unsigned long Dmamode, unsigned long Dmach);
	[DllImport("apigpib3.dll")] unsigned long GpExit3(void);
	[DllImport("apigpib3.dll")] unsigned long GpComand3(array<unsigned long>^ Cmd);
	[DllImport("apigpib3.dll")] unsigned long GpDmainuse3(void);
	[DllImport("apigpib3.dll")] unsigned long GpStstop3(unsigned long Stp);
	[DllImport("apigpib3.dll")] unsigned long GpDmastop3(void);
	[DllImport("apigpib3.dll")] unsigned long GpPpollmode3(unsigned long Pmode);
	[DllImport("apigpib3.dll")] unsigned long GpStppoll3(array<unsigned long>^ Cmd, unsigned long Stppu);
	[DllImport("apigpib3.dll")] unsigned long GpExppoll3(unsigned long * Pprdata);
	[DllImport("apigpib3.dll")] unsigned long GpStwait3(unsigned long Buscode);
	[DllImport("apigpib3.dll")] unsigned long GpWaittime3(unsigned long Timeout);
	[DllImport("apigpib3.dll")] unsigned long GpReadbus3(unsigned long * Bussta);
	[DllImport("apigpib3.dll")] unsigned long GpSfile3(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib3.dll")] unsigned long GpRfile3(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib3.dll")] unsigned long GpSdc3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpDcl3(void);
	[DllImport("apigpib3.dll")] unsigned long GpGet3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpGtl3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpLlo3(void);
	[DllImport("apigpib3.dll")] unsigned long GpTct3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCrst3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCopc3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCwai3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCcls3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCtrg3(unsigned long Adr);
	[DllImport("apigpib3.dll")] unsigned long GpCpre3(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib3.dll")] unsigned long GpCese3(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib3.dll")] unsigned long GpCsre3(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib3.dll")] unsigned long GpQidn3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQopt3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpud3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQrdt3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQcal3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQlrn3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQtst3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQopc3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQemc3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQgmc3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQlmc3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQist3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpre3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQese3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQesr3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpsc3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQsre3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQstb3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQddt3(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpTaLaBit3(unsigned long TaLaSts);
	[DllImport("apigpib3.dll")] unsigned long GpBoardsts3(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib3.dll")] unsigned long GpSrqEvent3(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib3.dll")] unsigned long GpSrqEventEx3(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib3.dll")] unsigned long GpSrqOn3();
	[DllImport("apigpib3.dll")] unsigned long GpDevFind3(array<unsigned long>^ Fstb);
	[DllImport("apigpib3.dll")] unsigned long GpInpB3(unsigned short Port);
	[DllImport("apigpib3.dll")] unsigned long GpInpW3(unsigned short Port);
	[DllImport("apigpib3.dll")] unsigned long GpInpD3(unsigned short Port);
	[DllImport("apigpib3.dll")] unsigned long GpOutB3(unsigned short Port, Byte Dat);
	[DllImport("apigpib3.dll")] unsigned long GpOutW3(unsigned short Port, unsigned short Dat);
	[DllImport("apigpib3.dll")] unsigned long GpOutD3(unsigned short Port, unsigned long Dat);
	[DllImport("apigpib3.dll")] unsigned long GpSetEvent3(unsigned long EventOn);
	[DllImport("apigpib3.dll")] unsigned long GpSetEventSrq3(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib3.dll")] unsigned long GpSetEventDet3(int hWnd, unsigned short wMsg, unsigned long DetOn);
	[DllImport("apigpib3.dll")] unsigned long GpSetEventDec3(int hWnd, unsigned short wMsg, unsigned long DecOn);
	[DllImport("apigpib3.dll")] unsigned long GpSetEventIfc3(int hWnd, unsigned short wMsg, unsigned long IfcOn);
	[DllImport("apigpib3.dll")] unsigned long GpEnableNextEvent3(void);
	[DllImport("apigpib3.dll")] unsigned long GpSrqEx3(unsigned long Stb, unsigned long SrqFlag, unsigned long EoiFlag);
	[DllImport("apigpib3.dll")] unsigned long GpUpperCode3(unsigned long UpperCode);
	[DllImport("apigpib3.dll")] unsigned long GpCnvSettings3(String^ HeaderStr, String^ UnitStr, String^ SepStr, unsigned long SfxFlag);
	[DllImport("apigpib3.dll")] unsigned long GpCnvSettingsToStr3(unsigned long PlusFlag, unsigned long Digit, unsigned long CutDown);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToDbl3(String^ Str, double * DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToDblArray3(String^ Str, array<double>^ DblData, unsigned long * ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToFlt3(String^ Str, float * FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToFltArray3(String^ Str, array<float>^ FltData, unsigned long * ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvDblToStr3(StringBuilder^ Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvDblArrayToStr3(StringBuilder^ Str, unsigned long * StrSize, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvFltToStr3(StringBuilder^ Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvFltArrayToStr3(StringBuilder^ Str, unsigned long * StrSize, array<float>^ FltData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpPollEx3(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb, array<unsigned long>^ Psrq);
	[DllImport("apigpib3.dll")] unsigned long GpSlowMode3(unsigned long SlowTime);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvSettings3(unsigned long Settings);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvi3(array<Byte>^ Str, short* ShtData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCviArray3(array<Byte>^ Str, array<short>^ ShtData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvs3(array<Byte>^ Str, float* FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvsArray3(array<Byte>^ Str, array<float>^  FltData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvd3(array<Byte>^ Str, double* DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvdArray3(array<Byte>^ Str, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpTalkEx3(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListenEx3(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpTalkAsync3(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListenAsync3(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpCommandAsync3(array<unsigned long>^ Cmd);
	[DllImport("apigpib3.dll")] unsigned long GpCheckAsync3(unsigned long WaitFlag, unsigned long * ErrCode);
	[DllImport("apigpib3.dll")] unsigned long GpStopAsync3(void);
	[DllImport("apigpib3.dll")] unsigned long GpDevFindEx3(short Pad, short Sad, short * Lstn);
	[DllImport("apigpib3.dll")] unsigned long GpBoardstsEx3(unsigned long SetFlag, unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib3.dll")] unsigned long GpSmoothMode3(unsigned long Mode);

	[DllImport("apigpib3.dll")] unsigned long GpTalk3(unsigned long * Cmd, unsigned long Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListen3(unsigned long *  Cmd, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpPoll3(unsigned long * Cmd, unsigned long * Pstb);
	[DllImport("apigpib3.dll")] unsigned long GpComand3(unsigned long * Cmd);
	[DllImport("apigpib3.dll")] unsigned long GpStppoll3(unsigned long * Cmd, unsigned long Stppu);
	[DllImport("apigpib3.dll")] unsigned long GpSfile3(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib3.dll")] unsigned long GpRfile3(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib3.dll")] unsigned long GpQidn3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQopt3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpud3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQrdt3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQcal3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQlrn3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQtst3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQopc3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQemc3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQgmc3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQlmc3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQist3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpre3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQese3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQesr3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQpsc3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQsre3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQstb3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpQddt3(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpDevFind3(unsigned long * Fstb);
	[DllImport("apigpib3.dll")] unsigned long GpCnvSettings3(unsigned char * HeaderStr, unsigned char * UnitStr, unsigned char * SepStr, unsigned long SfxFlag);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToDbl3(unsigned char * Str, double * DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToDblArray3(unsigned char * Str, double* DblData, unsigned long * ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToFlt3(unsigned char * Str, float * FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvStrToFltArray3(unsigned char * Str, float * FltData, unsigned long * ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvDblToStr3(unsigned char * Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvDblArrayToStr3(unsigned char * Str, unsigned long * StrSize, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvFltToStr3(unsigned char * Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvFltArrayToStr3(unsigned char * Str, unsigned long * StrSize, float * FltData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpPollEx3(unsigned long * Cmd, unsigned long * Pstb, unsigned long * Psrq);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvi3(unsigned char * Str, short* ShtData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCviArray3(unsigned char * Str, short * ShtData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvs3(unsigned char * Str, float* FltData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvsArray3(unsigned char * Str, float *  FltData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvd3(unsigned char * Str, double* DblData);
	[DllImport("apigpib3.dll")] unsigned long GpCnvCvdArray3(unsigned char * Str, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib3.dll")] unsigned long GpTalkEx3(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListenEx3(unsigned long * Cmd, unsigned long * Srlen,unsigned char * Srbuf);
	[DllImport("apigpib3.dll")] unsigned long GpTalkAsync3(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpListenAsync3(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib3.dll")] unsigned long GpCommandAsync3(unsigned long * Cmd);

	[DllImport("apigpib4.dll")] unsigned long GpIni4();
	[DllImport("apigpib4.dll")] unsigned long GpIfc4(unsigned long IfcTime);
	[DllImport("apigpib4.dll")] unsigned long GpRen4(void);
	[DllImport("apigpib4.dll")] unsigned long GpResetren4(void);
	[DllImport("apigpib4.dll")] unsigned long GpTalk4(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListen4(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpPoll4(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb);
	[DllImport("apigpib4.dll")] unsigned long GpSrq4(unsigned long Eoi);
	[DllImport("apigpib4.dll")] unsigned long GpStb4(unsigned long Stb);
	[DllImport("apigpib4.dll")] unsigned long GpDelim4(unsigned long Delim, unsigned long Eoi);
	[DllImport("apigpib4.dll")] unsigned long GpTimeout4(unsigned long Timeout);
	[DllImport("apigpib4.dll")] unsigned long GpChkstb4(unsigned long * Stb, unsigned long * Eoi);
	[DllImport("apigpib4.dll")] unsigned long GpReadreg4(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib4.dll")] unsigned long GpDma4(unsigned long Dmamode, unsigned long Dmach);
	[DllImport("apigpib4.dll")] unsigned long GpExit4(void);
	[DllImport("apigpib4.dll")] unsigned long GpComand4(array<unsigned long>^ Cmd);
	[DllImport("apigpib4.dll")] unsigned long GpDmainuse4(void);
	[DllImport("apigpib4.dll")] unsigned long GpStstop4(unsigned long Stp);
	[DllImport("apigpib4.dll")] unsigned long GpDmastop4(void);
	[DllImport("apigpib4.dll")] unsigned long GpPpollmode4(unsigned long Pmode);
	[DllImport("apigpib4.dll")] unsigned long GpStppoll4(array<unsigned long>^ Cmd, unsigned long Stppu);
	[DllImport("apigpib4.dll")] unsigned long GpExppoll4(unsigned long * Pprdata);
	[DllImport("apigpib4.dll")] unsigned long GpStwait4(unsigned long Buscode);
	[DllImport("apigpib4.dll")] unsigned long GpWaittime4(unsigned long Timeout);
	[DllImport("apigpib4.dll")] unsigned long GpReadbus4(unsigned long * Bussta);
	[DllImport("apigpib4.dll")] unsigned long GpSfile4(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib4.dll")] unsigned long GpRfile4(array<unsigned long>^ Cmd, unsigned long Srlen, String^ Fname);
	[DllImport("apigpib4.dll")] unsigned long GpSdc4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpDcl4(void);
	[DllImport("apigpib4.dll")] unsigned long GpGet4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpGtl4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpLlo4(void);
	[DllImport("apigpib4.dll")] unsigned long GpTct4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCrst4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCopc4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCwai4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCcls4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCtrg4(unsigned long Adr);
	[DllImport("apigpib4.dll")] unsigned long GpCpre4(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib4.dll")] unsigned long GpCese4(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib4.dll")] unsigned long GpCsre4(unsigned long Adr, unsigned long Stb);
	[DllImport("apigpib4.dll")] unsigned long GpQidn4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQopt4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpud4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQrdt4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQcal4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQlrn4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQtst4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQopc4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQemc4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQgmc4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQlmc4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQist4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpre4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQese4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQesr4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpsc4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQsre4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQstb4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQddt4(unsigned long Adr, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpTaLaBit4(unsigned long TaLaSts);
	[DllImport("apigpib4.dll")] unsigned long GpBoardsts4(unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib4.dll")] unsigned long GpSrqEvent4(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib4.dll")] unsigned long GpSrqEventEx4(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib4.dll")] unsigned long GpSrqOn4();
	[DllImport("apigpib4.dll")] unsigned long GpDevFind4(array<unsigned long>^ Fstb);
	[DllImport("apigpib4.dll")] unsigned long GpInpB4(unsigned short Port);
	[DllImport("apigpib4.dll")] unsigned long GpInpW4(unsigned short Port);
	[DllImport("apigpib4.dll")] unsigned long GpInpD4(unsigned short Port);
	[DllImport("apigpib4.dll")] unsigned long GpOutB4(unsigned short Port, Byte Dat);
	[DllImport("apigpib4.dll")] unsigned long GpOutW4(unsigned short Port, unsigned short Dat);
	[DllImport("apigpib4.dll")] unsigned long GpOutD4(unsigned short Port, unsigned long Dat);
	[DllImport("apigpib4.dll")] unsigned long GpSetEvent4(unsigned long EventOn);
	[DllImport("apigpib4.dll")] unsigned long GpSetEventSrq4(int hWnd, unsigned short wMsg, unsigned long SrqOn);
	[DllImport("apigpib4.dll")] unsigned long GpSetEventDet4(int hWnd, unsigned short wMsg, unsigned long DetOn);
	[DllImport("apigpib4.dll")] unsigned long GpSetEventDec4(int hWnd, unsigned short wMsg, unsigned long DecOn);
	[DllImport("apigpib4.dll")] unsigned long GpSetEventIfc4(int hWnd, unsigned short wMsg, unsigned long IfcOn);
	[DllImport("apigpib4.dll")] unsigned long GpEnableNextEvent4(void);
	[DllImport("apigpib4.dll")] unsigned long GpSrqEx4(unsigned long Stb, unsigned long SrqFlag, unsigned long EoiFlag);
	[DllImport("apigpib4.dll")] unsigned long GpUpperCode4(unsigned long UpperCode);
	[DllImport("apigpib4.dll")] unsigned long GpCnvSettings4(String^ HeaderStr, String^ UnitStr, String^ SepStr, unsigned long SfxFlag);
	[DllImport("apigpib4.dll")] unsigned long GpCnvSettingsToStr4(unsigned long PlusFlag, unsigned long Digit, unsigned long CutDown);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToDbl4(String^ Str, double * DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToDblArray4(String^ Str, array<double>^ DblData, unsigned long * ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToFlt4(String^ Str, float * FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToFltArray4(String^ Str, array<float>^ FltData, unsigned long * ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvDblToStr4(StringBuilder^ Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvDblArrayToStr4(StringBuilder^ Str, unsigned long * StrSize, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvFltToStr4(StringBuilder^ Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvFltArrayToStr4(StringBuilder^ Str, unsigned long * StrSize, array<float>^ FltData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpPollEx4(array<unsigned long>^ Cmd, array<unsigned long>^ Pstb, array<unsigned long>^ Psrq);
	[DllImport("apigpib4.dll")] unsigned long GpSlowMode4(unsigned long SlowTime);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvSettings4(unsigned long Settings);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvi4(array<Byte>^ Str, short* ShtData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCviArray4(array<Byte>^ Str, array<short>^ ShtData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvs4(array<Byte>^ Str, float* FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvsArray4(array<Byte>^ Str, array<float>^  FltData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvd4(array<Byte>^ Str, double* DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvdArray4(array<Byte>^ Str, array<double>^ DblData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpTalkEx4(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListenEx4(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpTalkAsync4(array<unsigned long>^ Cmd, unsigned long * Srlen, String^ Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListenAsync4(array<unsigned long>^ Cmd, unsigned long * Srlen, StringBuilder^ Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpCommandAsync4(array<unsigned long>^ Cmd);
	[DllImport("apigpib4.dll")] unsigned long GpCheckAsync4(unsigned long WaitFlag, unsigned long * ErrCode);
	[DllImport("apigpib4.dll")] unsigned long GpStopAsync4(void);
	[DllImport("apigpib4.dll")] unsigned long GpDevFindEx4(short Pad, short Sad, short * Lstn);
	[DllImport("apigpib4.dll")] unsigned long GpBoardstsEx4(unsigned long SetFlag, unsigned long Reg, unsigned long * Preg);
	[DllImport("apigpib4.dll")] unsigned long GpSmoothMode4(unsigned long Mode);

	[DllImport("apigpib4.dll")] unsigned long GpTalk4(unsigned long * Cmd, unsigned long Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListen4(unsigned long *  Cmd, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpPoll4(unsigned long * Cmd, unsigned long * Pstb);
	[DllImport("apigpib4.dll")] unsigned long GpComand4(unsigned long * Cmd);
	[DllImport("apigpib4.dll")] unsigned long GpStppoll4(unsigned long * Cmd, unsigned long Stppu);
	[DllImport("apigpib4.dll")] unsigned long GpSfile4(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib4.dll")] unsigned long GpRfile4(unsigned long * Cmd, unsigned long Srlen, unsigned char * Fname);
	[DllImport("apigpib4.dll")] unsigned long GpQidn4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQopt4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpud4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQrdt4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQcal4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQlrn4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQtst4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQopc4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQemc4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQgmc4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQlmc4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQist4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpre4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQese4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQesr4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQpsc4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQsre4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQstb4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpQddt4(unsigned long Adr, unsigned long * Srlen, unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpDevFind4(unsigned long * Fstb);
	[DllImport("apigpib4.dll")] unsigned long GpCnvSettings4(unsigned char * HeaderStr, unsigned char * UnitStr, unsigned char * SepStr, unsigned long SfxFlag);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToDbl4(unsigned char * Str, double * DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToDblArray4(unsigned char * Str, double* DblData, unsigned long * ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToFlt4(unsigned char * Str, float * FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvStrToFltArray4(unsigned char * Str, float * FltData, unsigned long * ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvDblToStr4(unsigned char * Str, unsigned long * StrSize, double DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvDblArrayToStr4(unsigned char * Str, unsigned long * StrSize, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvFltToStr4(unsigned char * Str, unsigned long * StrSize, float FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvFltArrayToStr4(unsigned char * Str, unsigned long * StrSize, float * FltData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpPollEx4(unsigned long * Cmd, unsigned long * Pstb, unsigned long * Psrq);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvi4(unsigned char * Str, short* ShtData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCviArray4(unsigned char * Str, short * ShtData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvs4(unsigned char * Str, float* FltData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvsArray4(unsigned char * Str, float *  FltData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvd4(unsigned char * Str, double* DblData);
	[DllImport("apigpib4.dll")] unsigned long GpCnvCvdArray4(unsigned char * Str, double* DblData, unsigned long ArraySize);
	[DllImport("apigpib4.dll")] unsigned long GpTalkEx4(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListenEx4(unsigned long * Cmd, unsigned long * Srlen,unsigned char * Srbuf);
	[DllImport("apigpib4.dll")] unsigned long GpTalkAsync4(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpListenAsync4(unsigned long * Cmd, unsigned long * Srlen, unsigned char * Srbuf); 
	[DllImport("apigpib4.dll")] unsigned long GpCommandAsync4(unsigned long * Cmd);

	[DllImport("user32.dll")] short GetAsyncKeyState(int vKey);

	#define HLP_SAMPLES				274
	#define HLP_SAMPLES_MASTER		275
	#define HLP_SAMPLES_SLAVE		276
	#define HLP_SAMPLES_MLTMETER	463
	#define HLP_SAMPLES_DVS			278
	#define HLP_SAMPLES_OSCILLO		279
	#define HLP_SAMPLES_POLLING		382
	#define HLP_SAMPLES_PARALLEL	381
	#define HLP_SAMPLES_MLTLINE		383

	#define ID_TIMER				1
	#define ID_TIMER_TERMINATE		2
	#define ID_TIMER_TRANSMISSION	3
	#define ID_TIMER_RECEPTION		4
	#define TIMERCOUNT				100
	#define TIMERCOUNT_TERMINATE	3000
}

